if (script.onAwake) {
	script.onAwake();
	return;
};
/*
@typedef CustomFunctions
@property {Component.ScriptComponent} script 
@property {string} function 
*/
function checkUndefined(property, showIf, showIfValue){
   if (showIf && script[showIf] != showIfValue){
       return;
   }
   if (script[property] == undefined){
       throw new Error('Input ' + property + ' was not provided for the object ' + script.getSceneObject().name);
   }
}
// @input bool autostart = true
checkUndefined("autostart", undefined, undefined);
// @input string text
checkUndefined("text", undefined, undefined);
// @input int tooltipDirection {"widget":"combobox", "values":[{"label":"Left", "value":0}, {"label":"Right", "value":1}, {"label":"Top", "value":2}, {"label":"Bottom", "value":3}]}
checkUndefined("tooltipDirection", undefined, undefined);
// @ui {"widget":"group_start", "label":"Duration"}
// @input float appearDelay = "0" {"label":"Delay"}
checkUndefined("appearDelay", undefined, undefined);
// @input float appearDuration = "0.8" {"label":"Fade In"}
checkUndefined("appearDuration", undefined, undefined);
// @input float showDuration = "2.0" {"label":"Shown Time"}
checkUndefined("showDuration", undefined, undefined);
// @input float disappearDuration = "0.8" {"label":"Fade Out"}
checkUndefined("disappearDuration", undefined, undefined);
// @ui {"widget":"group_end"}
// @input Asset.ObjectPrefab tooltipPrefabWorld
checkUndefined("tooltipPrefabWorld", undefined, undefined);
// @input Asset.ObjectPrefab tooltipPrefabPixelsPoints
checkUndefined("tooltipPrefabPixelsPoints", undefined, undefined);
// @ui {"widget":"separator"}
// @input bool eventCallbacks
checkUndefined("eventCallbacks", undefined, undefined);
// @ui {"widget":"group_start", "label":"Event Callbacks", "showIf":"eventCallbacks"}
// @input int callbackType = "0" {"widget":"combobox", "values":[{"label":"None", "value":0}, {"label":"Behavior Script", "value":1}, {"label":"Behavior Custom", "value":2}, {"label":"Custom Function", "value":3}]}
checkUndefined("callbackType", undefined, undefined);
// @input Component.ScriptComponent[] onTooltipStartBehaviors {"showIf":"callbackType", "showIfValue":1}
checkUndefined("onTooltipStartBehaviors", "callbackType", 1);
// @input Component.ScriptComponent[] onTooltipFinishBehaviors {"showIf":"callbackType", "showIfValue":1}
checkUndefined("onTooltipFinishBehaviors", "callbackType", 1);
// @input string[] onTooltipStartCustomTriggers {"showIf":"callbackType", "showIfValue":2}
checkUndefined("onTooltipStartCustomTriggers", "callbackType", 2);
// @input string[] onTooltipFinishCustomTriggers {"showIf":"callbackType", "showIfValue":2}
checkUndefined("onTooltipFinishCustomTriggers", "callbackType", 2);
// @input CustomFunctions[] onTooltipStartFunctions {"showIf":"callbackType", "showIfValue":3}
// @input CustomFunctions[] onTooltipFinishFunctions {"showIf":"callbackType", "showIfValue":3}
// @ui {"widget":"group_end"}
var scriptPrototype = Object.getPrototypeOf(script);
if (!global.BaseScriptComponent){
   function BaseScriptComponent(){}
   global.BaseScriptComponent = BaseScriptComponent;
   global.BaseScriptComponent.prototype = scriptPrototype;
   global.BaseScriptComponent.prototype.__initialize = function(){};
   global.BaseScriptComponent.getTypeName = function(){ 
       throw new Error("Cannot get type name from the class, not decorated with @component");
   }
}
var Module = require("../../../../Modules/Src/Resources/Scripts/Tooltip");
Object.setPrototypeOf(script, Module.Tooltip.prototype);
script.__initialize();
if (script.onAwake) {
   script.onAwake();
}